unit ConnectForm;
{*******************************************************************************
  ServiceController Demo
  Written by David Clegg, davidclegg@optusnet.com.au.

  Form to specify a computer to connect to and control services on.
*******************************************************************************}

interface

uses
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data;

type
  TConnectForm = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    gbConnectTo: System.Windows.Forms.GroupBox;
    rbLocal: System.Windows.Forms.RadioButton;
    rbComputer: System.Windows.Forms.RadioButton;
    tbComputerName: System.Windows.Forms.TextBox;
    btnOK: System.Windows.Forms.Button;
    btnCancel: System.Windows.Forms.Button;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure TConnectForm_Load(sender: System.Object; e: System.EventArgs);
    procedure btnOK_Click(sender: System.Object; e: System.EventArgs);
    procedure tbComputerName_TextChanged(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  private
    { Private Declarations }
    FComputerName: string;
    procedure PopulateControls;
  public
    constructor Create;
    class function ShowConnectForm(var pComputerName: string): System.Windows.Forms.DialogResult;
  end;

  [assembly: RuntimeRequiredAttribute(TypeOf(TConnectForm))]

implementation

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TConnectForm.InitializeComponent;
begin
  Self.gbConnectTo := System.Windows.Forms.GroupBox.Create;
  Self.tbComputerName := System.Windows.Forms.TextBox.Create;
  Self.rbComputer := System.Windows.Forms.RadioButton.Create;
  Self.rbLocal := System.Windows.Forms.RadioButton.Create;
  Self.btnOK := System.Windows.Forms.Button.Create;
  Self.btnCancel := System.Windows.Forms.Button.Create;
  Self.gbConnectTo.SuspendLayout;
  Self.SuspendLayout;
  // 
  // gbConnectTo
  // 
  Self.gbConnectTo.Controls.Add(Self.tbComputerName);
  Self.gbConnectTo.Controls.Add(Self.rbComputer);
  Self.gbConnectTo.Controls.Add(Self.rbLocal);
  Self.gbConnectTo.Location := System.Drawing.Point.Create(10, 8);
  Self.gbConnectTo.Name := 'gbConnectTo';
  Self.gbConnectTo.Size := System.Drawing.Size.Create(276, 80);
  Self.gbConnectTo.TabIndex := 0;
  Self.gbConnectTo.TabStop := False;
  Self.gbConnectTo.Text := 'Select a Computer to connect to';
  // 
  // tbComputerName
  // 
  Self.tbComputerName.Location := System.Drawing.Point.Create(128, 44);
  Self.tbComputerName.Name := 'tbComputerName';
  Self.tbComputerName.Size := System.Drawing.Size.Create(130, 20);
  Self.tbComputerName.TabIndex := 2;
  Self.tbComputerName.Text := '';
  Include(Self.tbComputerName.TextChanged, Self.tbComputerName_TextChanged);
  // 
  // rbComputer
  // 
  Self.rbComputer.Location := System.Drawing.Point.Create(16, 42);
  Self.rbComputer.Name := 'rbComputer';
  Self.rbComputer.Size := System.Drawing.Size.Create(120, 24);
  Self.rbComputer.TabIndex := 1;
  Self.rbComputer.Text := 'Another Computer';
  // 
  // rbLocal
  // 
  Self.rbLocal.Location := System.Drawing.Point.Create(16, 18);
  Self.rbLocal.Name := 'rbLocal';
  Self.rbLocal.TabIndex := 0;
  Self.rbLocal.Text := 'This Computer';
  // 
  // btnOK
  // 
  Self.btnOK.DialogResult := System.Windows.Forms.DialogResult.OK;
  Self.btnOK.Location := System.Drawing.Point.Create(120, 98);
  Self.btnOK.Name := 'btnOK';
  Self.btnOK.TabIndex := 1;
  Self.btnOK.Text := 'OK';
  Include(Self.btnOK.Click, Self.btnOK_Click);
  // 
  // btnCancel
  // 
  Self.btnCancel.DialogResult := System.Windows.Forms.DialogResult.Cancel;
  Self.btnCancel.Location := System.Drawing.Point.Create(208, 98);
  Self.btnCancel.Name := 'btnCancel';
  Self.btnCancel.TabIndex := 2;
  Self.btnCancel.Text := 'Cancel';
  // 
  // TConnectForm
  // 
  Self.AcceptButton := Self.btnOK;
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.CancelButton := Self.btnCancel;
  Self.ClientSize := System.Drawing.Size.Create(296, 132);
  Self.Controls.Add(Self.btnCancel);
  Self.Controls.Add(Self.btnOK);
  Self.Controls.Add(Self.gbConnectTo);
  Self.FormBorderStyle := System.Windows.Forms.FormBorderStyle.FixedSingle;
  Self.MaximizeBox := False;
  Self.MinimizeBox := False;
  Self.Name := 'TConnectForm';
  Self.ShowInTaskbar := False;
  Self.StartPosition := System.Windows.Forms.FormStartPosition.CenterScreen;
  Self.Text := 'Connect to...';
  Include(Self.Load, Self.TConnectForm_Load);
  Self.gbConnectTo.ResumeLayout(False);
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TConnectForm.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TConnectForm.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
end;

class function TConnectForm.ShowConnectForm(
  var pComputerName: string): System.Windows.Forms.DialogResult;
var
  lConnectForm: TConnectForm;
begin
  lConnectForm := TConnectForm.Create;
  lConnectForm.FComputerName := pComputerName;
  Result := lConnectForm.ShowDialog;
  if Result = System.Windows.Forms.DialogResult.OK then
    pComputerName := lConnectForm.FComputerName;
end;

procedure TConnectForm.tbComputerName_TextChanged(sender: System.Object; e: System.EventArgs);
begin
  rbComputer.Checked := tbComputerName.Text <> '';
  rbLocal.Checked := not rbComputer.Checked;
end;

procedure TConnectForm.btnOK_Click(sender: System.Object; e: System.EventArgs);
begin
  if rbLocal.Checked then
    FComputerName := ''
  else
    FComputerName := tbComputerName.Text;
end;

procedure TConnectForm.TConnectForm_Load(sender: System.Object; e: System.EventArgs);
begin
  PopulateControls;
end;

procedure TConnectForm.PopulateControls;
begin
  if FComputerName = '' then
    rbLocal.Checked := true
  else
  begin
    rbComputer.Checked := true;
    tbComputerName.Text := FComputerName;
  end;
end;

end.
